--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A structure that keeps track of combat session data that lasts for the duration of combat. It is mainly used for AI decision making. It is not saved to a savegame.
--- @class tes3combatSession
--- @field alchemyPriority number No description yet available.
--- @field castableSpells tes3spell[] The list of castable spells that the AI will consider using during combat. This includes both offensive and defensive spells. It is initialized at the start of combat and may be changed by mods at any time. Like other combat session data, it is not saved to a savegame.
--- 
--- This is actually a list collection type. You can use these methods on castableSpells:
--- 
--- castableSpells:add(tes3spell)
--- castableSpells:find(tes3spell) -> index
--- castableSpells:erase(index)
--- castableSpells:clear()
--- 
--- Note that ids cannot be used with these methods.
--- 
--- @field data table A generic lua table that data can be written to, and synced to/from the save. All information stored must be valid for serialization to json.
--- 
--- There is a guide available [here](https://mwse.github.io/MWSE/guides/storing-data/) on using this table.
--- @field distance number The combat distance.
--- @field lastUseTimestamp number Used by the MCP to implement an alchemy use cooldown for actor AI.
--- @field mobile tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer *Read-only*. Convenience access back to the associated actor.
--- @field potionUseFlag number No description yet available.
--- @field selectedAction integer The current combat action, until the next AI decision. This can be changed to affect what the AI is doing in the short term. From observed behavior, this roughly maps to:
--- 
--- Value | Behavior
--- ----- | ---------
--- 0     | Undecided
--- 1     | Use melee weapon
--- 2     | Use marksman weapon
--- 3     | Use hand to hand attacks
--- 4     | Use on-touch offensive spell
--- 5     | Use on-target offensive spell
--- 6     | Use summon spell
--- 7     | Flee
--- 8     | Cast on-self empowering spell (For example, Ancestor Guardian)
--- 9     | Use alchemy item
--- 10    | Use enchanted item
--- 
--- @field selectedItem tes3itemStack The potion or an enchanted item which was chosen at the last AI decision, if it was a magic item action. Changing this has no effect outside of the decision function, instead use `tes3mobileActor.equipMagic` to change the next castable.
--- @field selectedShield tes3equipmentStack *Read-only*. The shield which was chosen at the last physical attack AI decision.
--- @field selectedSpell tes3spell The spell which was chosen at the last AI decision, if it was a spell cast action. Changing this has no effect outside of the decision function, instead use `tes3mobileActor.equipMagic` to change the next castable.
--- @field selectedWeapon tes3equipmentStack *Read-only*. The weapon which was chosen at the last physical attack AI decision.
--- @field spellPriority number No description yet available.
tes3combatSession = {}

--- This method equips an item to the mobile in this combat sesion.
--- @param equipmentStack tes3equipmentStack An item to equip.
function tes3combatSession:changeEquipment(equipmentStack) end

--- Selects the alchemy item with the greatest value, for a given effect ID and loads it into the `selectedItem` property.
--- @param id tes3.effect|integer Maps to values in [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @return number result No description yet available.
function tes3combatSession:selectAlchemyWithEffect(id) end

